# Through The Years Pricing

## Description
This mod adjusts crop prices based on the current in-game year for roleplay scenarios in Farming Simulator 25. Experience realistic historical pricing that changes as your farm progresses through different years, adding an extra layer of immersion to your gameplay.

## Features
- **Year-Based Pricing**: Crop prices automatically adjust based on the current in-game year
- **Historical Accuracy**: Pricing data reflects realistic market conditions for different time periods
- **Automatic Updates**: Prices are applied when the game loads based on the current year
- **Multiplayer Support**: Fully compatible with multiplayer sessions
- **Extensive Crop Coverage**: Supports all major crops and fill types
- **Customizable Data**: Pricing information stored in an easily editable XML file

## How It Works
When you load your savegame, the mod:
1. Reads the current in-game year from your save
2. Loads pricing data from `pricingData.xml`
3. Finds the pricing multipliers for that specific year
4. Applies the multipliers to all configured crops
5. Updates the game's fill type prices accordingly

Prices are based on multipliers of the original game values, so the mod works seamlessly with any map or other mods that modify base prices.

## Installation
1. Download the mod files
2. Place the entire `HistoricalPricing` folder in your Farming Simulator 25 mods directory
   - **Windows**: `Documents\My Games\FarmingSimulator2025\mods`
   - **Mac**: `~/Library/Application Support/FarmingSimulator2025/mods`
3. Start the game and activate the mod in the mod menu

## Usage
1. Activate the mod in the game's mod menu
2. Start or load your savegame
3. Check the game log to see which year's pricing is being applied
4. Sell your crops at historically accurate prices!

The mod automatically detects your current year and applies the appropriate pricing. As you progress through years in your savegame, prices will automatically update when you reload.

## Pricing Data
The mod includes a `pricingData.xml` file that contains pricing multipliers for different years and crops. You can customize this file to:
- Add more years
- Modify existing multipliers
- Add support for additional crops
- Create your own pricing scenarios

### XML Structure
```xml
<ttyPricing>
    <year value="2024">
        <crop name="WHEAT" price="1.0"/>
        <crop name="BARLEY" price="0.95"/>
        <!-- More crops... -->
    </year>
    <!-- More years... -->
</ttyPricing>
```

## Supported Crops
The mod can adjust prices for any fill type in the game, including:
- Wheat, Barley, Oat, Canola
- Corn, Soybean, Sunflower
- Sugar Beet, Potato
- Cotton, Sorghum
- And many more...

## Compatibility
- **Multiplayer**: Fully supported with proper synchronization
- **Savegames**: Safe to add to existing savegames
- **Other Mods**: Compatible with most economy and crop mods
- **Maps**: Works with any map
- **Game Version**: Farming Simulator 25

## Console Output
The mod provides detailed logging to help you understand what's happening:
```
--> Historical Pricing: Mod Loaded
--> Historical Pricing: XML Data Loaded
--> Historical Pricing: Current Year is 2024
--> Historical Pricing: Found pricing data for year 2024
--> Historical Pricing: Adjusted WHEAT price to 0.5234 (Multiplier: 1.00)
```

## Customization
To create your own pricing scenarios:
1. Open `pricingData.xml` in a text editor
2. Add new `<year>` entries with your desired year value
3. Add `<crop>` entries with fill type names and price multipliers
4. Save the file and reload your game

**Tip**: Check the game log to see the exact fill type names used by the game.

## Troubleshooting
If prices aren't changing:
1. Check the game log for Historical Pricing messages
2. Verify that `pricingData.xml` exists in the mod folder
3. Ensure your current year has pricing data defined
4. Make sure the crop names in the XML match the game's fill type names

If no pricing data exists for your current year, the mod will use default game prices and log a message.

## Version
1.0.0.0

## Author
MrRoco

## Additional Resources
The mod includes a `pricing.pdf` file with additional information about pricing data and historical context.

## License
This mod is provided as-is for personal use in Farming Simulator 25.
